//
//  TapTapsViewController.m
//  TapTaps
//
//  Created by Robert Górczyński on 11-07-26.
//

#import "TapTapsViewController.h"

@implementation TapTapsViewController
@synthesize singleLabel; 
@synthesize doubleLabel; 
@synthesize tripleLabel; 
@synthesize quadrupleLabel; 

- (void)tap1 { 
    singleLabel.text = @"Wykryto pojedyncze naciśnięcie"; 
    [self performSelector:@selector(eraseMe:) 
			   withObject:singleLabel afterDelay:1.6f]; 
} 

- (void)tap2 { 
    doubleLabel.text = @"Wykryto podwójne naciśnięcie"; 
    [self performSelector:@selector(eraseMe:) 
			   withObject:doubleLabel afterDelay:1.6f]; 
} 

- (void)tap3 { 
    tripleLabel.text = @"Wykryto potrójne naciśnięcie";
    [self performSelector:@selector(eraseMe:) 
			   withObject:tripleLabel afterDelay:1.6f]; 
} 

- (void)tap4 { 
    quadrupleLabel.text = @"Wykryto poczwórne naciśnięcie"; 
    [self performSelector:@selector(eraseMe:) 
			   withObject:quadrupleLabel afterDelay:1.6f]; 
} 

- (void)eraseMe:(UITextField *)textField { 
    textField.text = @""; 
} 

// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
    [super viewDidLoad];

    UITapGestureRecognizer *singleTap = 
	[[[UITapGestureRecognizer alloc] initWithTarget:self 
											 action:@selector(tap1)] autorelease]; 
    singleTap.numberOfTapsRequired = 1; 
    singleTap.numberOfTouchesRequired = 1; 
    [self.view addGestureRecognizer:singleTap]; 
	
    UITapGestureRecognizer *doubleTap = 
	[[[UITapGestureRecognizer alloc] initWithTarget:self 
											 action:@selector(tap2)] autorelease]; 
    doubleTap.numberOfTapsRequired = 2; 
    doubleTap.numberOfTouchesRequired = 1; 
    [self.view addGestureRecognizer:doubleTap]; 
    [singleTap requireGestureRecognizerToFail:doubleTap];
    UITapGestureRecognizer *tripleTap = 
	[[[UITapGestureRecognizer alloc] initWithTarget:self 
											 action:@selector(tap3)] autorelease]; 
    tripleTap.numberOfTapsRequired = 3; 
    tripleTap.numberOfTouchesRequired = 1; 
    [self.view addGestureRecognizer:tripleTap]; 
    [doubleTap requireGestureRecognizerToFail:tripleTap]; 
	
    UITapGestureRecognizer *quadrupleTap = 
	[[[UITapGestureRecognizer alloc] initWithTarget:self 
											 action:@selector(tap4)] autorelease]; 
    quadrupleTap.numberOfTapsRequired = 4; 
    quadrupleTap.numberOfTouchesRequired = 1; 
    [self.view addGestureRecognizer:quadrupleTap]; 
    [tripleTap requireGestureRecognizerToFail:quadrupleTap]; 	
}


- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.singleLabel = nil; 
	self.doubleLabel = nil; 
	self.tripleLabel = nil; 
	self.quadrupleLabel = nil; 
	[super viewDidUnload]; 	
}


- (void)dealloc {
    [singleLabel release]; 
    [doubleLabel release]; 
    [tripleLabel release]; 
    [quadrupleLabel release]; 	
    [super dealloc];
}

@end
